<?php

declare(strict_types=1);

define('ROOT_PATH', dirname(__DIR__));
define('APP_PATH', ROOT_PATH . '/app');
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('BASE_URL', rtrim(($_ENV['APP_URL'] ?? 'http://localhost/accounting2/public'), '/') . '/');

// Load env file if exists
$envFile = ROOT_PATH . '/.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        if (strpos($line, '=') !== false) {
            [$key, $value] = explode('=', $line, 2);
            $_ENV[trim($key)] = trim($value, " \t\n\r\0\x0B\"'");
        }
    }
}

$config = require APP_PATH . '/config.php';
$sessionConfig = $config['session'];

session_name($sessionConfig['name']);
session_set_cookie_params([
    'lifetime' => $sessionConfig['lifetime'],
    'path' => $sessionConfig['path'],
    'secure' => $sessionConfig['secure'],
    'httponly' => $sessionConfig['httponly'],
    'samesite' => $sessionConfig['samesite'],
]);
session_start();

require_once APP_PATH . '/config.php';
require_once APP_PATH . '/db.php';
require_once APP_PATH . '/helpers.php';
require_once APP_PATH . '/csrf.php';
require_once APP_PATH . '/auth.php';
require_once APP_PATH . '/permissions.php';
