<?php

declare(strict_types=1);

function config(): array
{
    static $config = null;
    if ($config === null) {
        $config = require APP_PATH . '/config.php';
    }
    return $config;
}

function e(string $str): string
{
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

function redirect(string $url, int $status = 302): never
{
    header("Location: $url", true, $status);
    exit;
}

function redirect_route(string $route, array $params = []): never
{
    $query = http_build_query(array_merge(['r' => $route], $params));
    redirect(BASE_URL . '?' . $query);
}

function flash(string $key, mixed $message = null): mixed
{
    if ($message === null) {
        $value = $_SESSION['_flash'][$key] ?? null;
        unset($_SESSION['_flash'][$key]);
        return $value;
    }
    $_SESSION['_flash'][$key] = $message;
    return null;
}

function flash_set(string $key, mixed $message): void
{
    $_SESSION['_flash'][$key] = $message;
}

function old(string $key, mixed $default = ''): mixed
{
    return $_SESSION['_old'][$key] ?? $default;
}

function format_money(float $amount, int $decimals = 2): string
{
    return number_format($amount, $decimals);
}

function format_date(string $date): string
{
    return date('d-M-Y', strtotime($date));
}

function decimal_add(string $a, string $b): string
{
    return bcadd((string) $a, (string) $b, 2);
}

function decimal_sub(string $a, string $b): string
{
    return bcsub((string) $a, (string) $b, 2);
}

function decimal_compare(string $a, string $b): int
{
    return bccomp((string) $a, (string) $b, 2);
}
