<?php

declare(strict_types=1);

require_once __DIR__ . '/auth.php';

function can(string $permission): bool
{
    $user = auth_user();
    if (!$user) {
        return false;
    }

    $permissions = $_SESSION['user_permissions'] ?? null;
    if ($permissions === null) {
        $permissions = load_user_permissions($user['id']);
        $_SESSION['user_permissions'] = $permissions;
    }

    return in_array('*', $permissions, true) || in_array($permission, $permissions, true);
}

function load_user_permissions(int $userId): array
{
    $pdo = db();
    $stmt = $pdo->prepare("
        SELECT DISTINCT p.code
        FROM permissions p
        INNER JOIN role_permissions rp ON rp.permission_id = p.id
        INNER JOIN user_roles ur ON ur.role_id = rp.role_id
        WHERE ur.user_id = ?
    ");
    $stmt->execute([$userId]);
    return array_column($stmt->fetchAll(), 'code');
}

function require_permission(string $permission): void
{
    if (!can($permission)) {
        flash_set('error', 'Access denied.');
        redirect_route('company/dashboard');
    }
}

function can_override_lock(): bool
{
    return can('admin.override_lock');
}
