<?php

declare(strict_types=1);

require_once APP_PATH . '/auth.php';
require_once APP_PATH . '/permissions.php';

$routeMap = [
    // Auth
    'login' => ['auth_login_page', null, false],
    'login_post' => ['auth_login_post', null, false],
    'logout' => ['auth_logout_action', null, false],

    // Company + FY
    'company/dashboard' => ['company_dashboard_page', 'company.view', true],
    'company/list' => ['company_list_page', 'company.view', true],
    'company/create' => ['company_create_page', 'company.create', true],
    'company/save' => ['company_save_action', 'company.create', true],
    'company/fy/list' => ['company_fy_list_page', 'company.view', true],
    'company/fy/create' => ['company_fy_create_page', 'company.create', true],
    'company/fy/save' => ['company_fy_save_action', 'company.create', true],
    'company/fy/select' => ['company_fy_select_action', 'company.view', true],
    'company/fy/ajax' => ['company_fy_ajax', 'company.view', true],
    'company/lock/list' => ['company_lock_list_page', 'company.lock', true],
    'company/lock/save' => ['company_lock_save_action', 'company.lock', true],

    // Masters
    'masters/groups' => ['masters_groups_page', 'masters.view', true],
    'masters/group/create' => ['masters_group_create_page', 'masters.create', true],
    'masters/group/save' => ['masters_group_save_action', 'masters.create', true],
    'masters/ledgers' => ['masters_ledgers_page', 'masters.view', true],
    'masters/ledger/create' => ['masters_ledger_create_page', 'masters.create', true],
    'masters/ledger/save' => ['masters_ledger_save_action', 'masters.create', true],
    'masters/openings' => ['masters_openings_page', 'masters.view', true],
    'masters/openings/save' => ['masters_openings_save_action', 'masters.create', true],

    // Accounts - Vouchers
    'accounts/vouchers' => ['vouchers_list_page', 'accounts.view', true],
    'accounts/voucher/new' => ['voucher_new_page', 'accounts.create', true],
    'accounts/voucher/save' => ['voucher_save_action', 'accounts.create', true],
    'accounts/voucher/view' => ['voucher_view_page', 'accounts.view', true],
    'accounts/voucher/post' => ['voucher_post_action', 'accounts.post', true],
    'accounts/voucher/void' => ['voucher_void_action', 'accounts.void', true],

    // Sales
    'sales/invoices' => ['sales_invoices_list_page', 'sales.view', true],
    'sales/invoice/new' => ['sales_invoice_new_page', 'sales.create', true],
    'sales/invoice/save' => ['sales_invoice_save_action', 'sales.create', true],
    'sales/invoice/view' => ['sales_invoice_view_page', 'sales.view', true],
    'sales/invoice/post' => ['sales_invoice_post_action', 'sales.post', true],
    'sales/invoice/cancel' => ['sales_invoice_cancel_action', 'sales.cancel', true],

    // Purchase
    'purchase/bills' => ['purchase_bills_list_page', 'purchase.view', true],
    'purchase/bill/new' => ['purchase_bill_new_page', 'purchase.create', true],
    'purchase/bill/save' => ['purchase_bill_save_action', 'purchase.create', true],
    'purchase/bill/view' => ['purchase_bill_view_page', 'purchase.view', true],
    'purchase/bill/post' => ['purchase_bill_post_action', 'purchase.post', true],
    'purchase/bill/cancel' => ['purchase_bill_cancel_action', 'purchase.cancel', true],

    // Tax
    'tax/components' => ['tax_components_page', 'tax.view', true],
    'tax/rates' => ['tax_rates_page', 'tax.view', true],

    // Reports
    'reports/trial_balance' => ['reports_trial_balance_page', 'reports.view', true],
    'reports/ledger' => ['reports_ledger_page', 'reports.view', true],
    'reports/pl' => ['reports_pl_page', 'reports.view', true],
    'reports/bs' => ['reports_bs_page', 'reports.view', true],
    'reports/daybook' => ['reports_daybook_page', 'reports.view', true],
    'reports/outstanding' => ['reports_outstanding_page', 'reports.view', true],
    'reports/sales_register' => ['reports_sales_register_page', 'reports.view', true],
    'reports/purchase_register' => ['reports_purchase_register_page', 'reports.view', true],

    // Bank
    'bank/statements' => ['bank_statements_page', 'bank.view', true],
    'bank/reconcile' => ['bank_reconcile_page', 'bank.reconcile', true],

    // Admin
    'admin/users' => ['users_list_page', 'admin.users', true],
    'admin/user/create' => ['user_create_page', 'admin.users', true],
    'admin/user/save' => ['user_save_action', 'admin.users', true],
    'admin/roles' => ['roles_list_page', 'admin.roles', true],
    'admin/audit' => ['audit_log_page', 'admin.audit', true],
];

function dispatch(string $route): void
{
    global $routeMap;

    $route = trim($route, '/');
    if ($route === '') {
        $route = 'login';
    }

    $handler = $routeMap[$route] ?? null;
    if (!$handler) {
        http_response_code(404);
        echo '404 - Page not found';
        return;
    }

    [$callback, $permission, $requireAuth] = $handler;

    if ($requireAuth) {
        auth_require();
        if ($permission) {
            require_permission($permission);
        }
    }

    if (!function_exists($callback)) {
        require_once APP_PATH . '/features/auth/auth_pages.php';
        require_once APP_PATH . '/features/company/company_pages.php';
        require_once APP_PATH . '/features/company/company_service.php';
        require_once APP_PATH . '/features/company/company_repo.php';
        require_once APP_PATH . '/features/masters/masters_pages.php';
        require_once APP_PATH . '/features/masters/masters_service.php';
        require_once APP_PATH . '/features/masters/masters_repo.php';
        require_once APP_PATH . '/features/accounts/vouchers_pages.php';
        require_once APP_PATH . '/features/accounts/vouchers_service.php';
        require_once APP_PATH . '/features/accounts/vouchers_repo.php';
        require_once APP_PATH . '/features/accounts/posting_engine.php';
        require_once APP_PATH . '/features/sales/sales_pages.php';
        require_once APP_PATH . '/features/sales/sales_service.php';
        require_once APP_PATH . '/features/sales/sales_repo.php';
        require_once APP_PATH . '/features/purchase/purchase_pages.php';
        require_once APP_PATH . '/features/purchase/purchase_service.php';
        require_once APP_PATH . '/features/purchase/purchase_repo.php';
        require_once APP_PATH . '/features/tax/tax_service.php';
        require_once APP_PATH . '/features/tax/tax_repo.php';
        require_once APP_PATH . '/features/tax/tax_reports_pages.php';
        require_once APP_PATH . '/features/reports/reports_pages.php';
        require_once APP_PATH . '/features/reports/reports_service.php';
        require_once APP_PATH . '/features/reports/reports_repo.php';
        require_once APP_PATH . '/features/bank/bank_pages.php';
        require_once APP_PATH . '/features/bank/bank_service.php';
        require_once APP_PATH . '/features/bank/bank_repo.php';
        require_once APP_PATH . '/features/admin/users_pages.php';
        require_once APP_PATH . '/features/admin/users_service.php';
        require_once APP_PATH . '/features/admin/users_repo.php';
    }

    if (function_exists($callback)) {
        $callback();
    } else {
        http_response_code(500);
        echo '500 - Handler not found: ' . $callback;
    }
}
