// Company/FY select - load FYs via AJAX when company changes
document.addEventListener('DOMContentLoaded', function() {
    const companySelect = document.getElementById('company_select');
    const fyGroup = document.getElementById('fy_group');
    if (companySelect && fyGroup) {
        companySelect.addEventListener('change', function() {
            const cid = this.value;
            const fySelect = fyGroup.querySelector('select');
            fySelect.innerHTML = '<option value="">-- Select --</option>';
            if (!cid) return;
            fetch('?r=company/fy/ajax&company_id=' + cid)
                .then(r => r.json())
                .then(data => {
                    data.forEach(fy => {
                        const opt = document.createElement('option');
                        opt.value = fy.id;
                        opt.textContent = fy.name + ' (' + fy.start_date + ' - ' + fy.end_date + ')';
                        fySelect.appendChild(opt);
                    });
                })
                .catch(() => {});
        });
    }
});
